/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.world.generate;

import java.util.Random;
import net.jayjay.dangerzone.world.noise.PerlinNoiseGenerator;

public class PerlinNoiseTerrainGenerator {
    private PerlinNoiseGenerator noiseGenerator;
    private PerlinNoiseGenerator detailNoiseGenerator;

    public PerlinNoiseTerrainGenerator(Random random) {
        this.noiseGenerator = new PerlinNoiseGenerator(random);
        this.detailNoiseGenerator = new PerlinNoiseGenerator(new Random(random.nextLong()));
    }

    public int[] generateTerrain(int xOffset, int zOffset, int width, int height, int depth) {
        int[] terrain = new int[width * height * depth];
        double baseScale = 0.005;
        double detailScale = 0.007;
        double heightScale = (double)depth * 0.5;
        double detailHeightScale = (double)depth * 0.1;
        int x = 0;
        while (x < width) {
            int z = 0;
            while (z < height) {
                double detailNoiseValue;
                int detailHeight;
                double baseNoiseValue = this.noiseGenerator.generateNoise((double)(x + xOffset) * baseScale, (double)(z + zOffset) * baseScale, 0.0);
                int baseHeight = (int)((baseNoiseValue + 1.0) * heightScale);
                int terrainHeight = baseHeight + (detailHeight = (int)(((detailNoiseValue = this.detailNoiseGenerator.generateNoise((double)(x + xOffset) * detailScale, (double)(z + zOffset) * detailScale, 0.0)) + 1.0) * detailHeightScale));
                if (terrainHeight < 0) {
                    terrainHeight = 0;
                }
                if (terrainHeight >= depth) {
                    terrainHeight = depth - 1;
                }
                int y = 0;
                while (y < depth) {
                    int index = (x + z * width) * depth + y;
                    terrain[index] = y <= terrainHeight ? 1 : 0;
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        return terrain;
    }
}

